#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>

#include "global.h"
#include "attribute.h"
#include "tcl_interface.h"
#include "field.h"
#include "utils.h"

int num_fields1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(num_fields()));
return TCL_OK;
}

int field_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: field_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: field_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: field_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,get_field(i)->name,NULL);
return TCL_OK;
}


int find_field(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_field requires one argument",NULL);
	return TCL_ERROR;
	}
for(i=0;i<num_fields();i++)
	if(!strcmp(get_field(i)->name,argv[1])){
		Tcl_SetObjResult(interp,Tcl_NewIntObj(i));
		return TCL_OK;
		}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
return TCL_OK;
}

int field_x_dim(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: field_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: field_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: field_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(get_field(i)->x_size));
return TCL_OK;
}

int field_y_dim(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: field_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: field_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: field_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(get_field(i)->y_size));
return TCL_OK;
}

int seed_fields1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
seed_fields();
set_time(0);
return TCL_OK;
}

#define s TCL_FIELDS_s

char s[2000];
char u[20];

int agent_attr_value(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
int first;
long i;
FIELD *f;
long x,y;
long attr;
AGENT *a;
ATTRIBUTE *at;
Tcl_ResetResult(interp);
if(argc!=5){
	Tcl_AppendResult(interp,"ERROR: agent_attr_value requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: agent_attr_value: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: agent_attr_value: index too big",NULL);
	return TCL_ERROR;
	}
f=get_field(i);		
x=atol(argv[2]);
y=atol(argv[3]);
if((x<0)||(y<0)){
	Tcl_AppendResult(interp,"",NULL);
	return TCL_OK;
	}
if((x>=f->x_size)||(y>=f->y_size)){
	Tcl_AppendResult(interp,"",NULL);
	return TCL_OK;
	}
a=f->agent[x][y];	
attr=atol(argv[4]);			
if(attr<0){
	Tcl_AppendResult(interp,get_agentclass_from_handle(a->class_handle)->class_name,NULL);
	return TCL_OK;
	}
if(attr>num_attributes()){
	Tcl_AppendResult(interp,"",NULL);
	return TCL_OK;
	}
at=get_attribute(attr);
switch(at->type){	
	case TYPE_BOOL: 
		sprintf(s,"%s",a->attribute[attr] ? "yes" : "no");
		break;
	case TYPE_INT:
		sprintf(s,"%lld",a->attribute[attr]);	
		break;
	case TYPE_SET:
		sprintf(s,"");
		break;
	case TYPE_REPERTOIRE:
		first=1;
		for(i=0;i<at->param.rep.size;i++){
			if(a->attribute[attr] & (((u64)1)<<i)){
				if(first){
					if(i==ACTIVATED(a->attribute[attr]))
						sprintf(s,"*%d*",i);
						else
						sprintf(s,"%d",i);
					first=0;
					} else {
					if(i==ACTIVATED(a->attribute[attr]))
						sprintf(u,",*%d*",i);
						else
						sprintf(u,",%d",i);
					strcat(s,u);
					}
				}
			}
		if(first)sprintf(s,"empty");
		break;
	default:
		sprintf(s,"");
		break;
	}
Tcl_AppendResult(interp,s,NULL);
return TCL_OK;
}
